/** ID html prvků */
const vstupniPole = 'vstupniPole';
const vystupniPole = 'vystupniPole';
const napovedniPole = 'napovedniPole';


/**
 * Aby to fungovalo i v MSIE 6.
 * @return AJAXový objekt.
 */
function getXmlHttpRequestObject() {
    if (window.XMLHttpRequest) {
        return new XMLHttpRequest();
    } else if(window.ActiveXObject) {
        return new ActiveXObject("Microsoft.XMLHTTP");
    } else {
        alert("Váš prohlížeč nepodporuje AJAX. Pořiďte si méně zastaralý prohlížeč, nejlépe Firefox.");
        return null;
    }
}

/** Náš AJAXový objekt. */
var ajax = getXmlHttpRequestObject();

/**
 * Vrací vstup od uživatele.
 * @return SQL příkaz zadaný uživatelem.
 **/
function getSQL() {
    return document.getElementById(vstupniPole).innerHTML;
}

/**
 * Zobrazí text na požadovaném místě.
 * @param text text k zobrazení
 * @param kde id prvku, do kterého se má text vypsat
 **/
function zobraz(text, kde) {
    document.getElementById(kde).innerHTML = text + '<p>&nbsp;<!-- Šťastné hackování ;-) --></p>';
}

/**
 * Zobrazí text ve výstupním poli.
 * @param text text k zobrazení
 **/
function zobrazVystup(text) {
    zobraz(text, vystupniPole);
}

/**
 * Zobrazí text ve vstupním poli.
 * Požijeme pro načtení SQL příkazu z historie.
 * @param text text k zobrazení
 **/
function zobrazVstup(text) {
    zobraz(text, vstupniPole);
}

/**
 * Zobrazí text ve poli pro nápovědu.
 * @param text text k zobrazení
 **/
function zobrazNapovedu(text) {
    zobraz(text, napovedniPole);
}

/** Jednoduchá AJAXová funkce, načte obsah souboru a zobrazí ho ve výstupním okně. */
function ajaxVykonatSQL() {
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        ajax.open("GET", 'vysledek.html', true);
        ajax.onreadystatechange = vykonatSQLVypis;
        ajax.send(null);
    }
    //zobrazNapovedu('Nějaká nápověda k danému příkazu.');
    //zobrazNapovedu(escape(getSQL()));
}

/** Pomocná funkce – postará se o vypsání v pravou chvíli. */
function vykonatSQLVypis() {
    if (ajax.readyState == 4) {
        zobrazVystup(ajax.responseText);
    }
}


/** Jednoduchá AJAXová funkce, načte obsah souboru a zobrazí ho ve výstupním okně. */
function ajaxZobrazitHistorii() {
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        ajax.open("GET", 'historie.html', true);
        ajax.onreadystatechange = zobrazitHistoriiVypis;
        ajax.send(null);
    }
}

/** Pomocná funkce – postará se o vypsání v pravou chvíli. */
function zobrazitHistoriiVypis() {
    if (ajax.readyState == 4) {
        zobrazVystup(ajax.responseText);
    }
}
