package cz.frantovo.postak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.internet.InternetAddress;

/**
 * Hromadná zpráva. Umí se rozdělit i na více dílčích zpráv,
 * které se vejdou do limitu příjemců SMTP serveru.
 *
 * @author fiki
 */
public class HromadnaZprava implements Cloneable {

	public enum FORMÁT {

		XHTML,
		PROSTÝ_TEXT,
		OBOJE
	}
	private static final Logger log = Logger.getLogger(HromadnaZprava.class.getName());
	/** Předmět zprávy */
	private String predmet;
	/** Adresa a případně jméno odesílatele */
	private InternetAddress odesilatel;
	/** Zda má být zpráva odeslána jako HTML nebo prostý text */
	private FORMÁT formát = FORMÁT.PROSTÝ_TEXT;
	/** Tělo zprávy - prostý text */
	private String text;
	/** Všichni příjemci této zprávy */
	private ArrayList<InternetAddressKomu> prijemci = new ArrayList<InternetAddressKomu>();
	/** Hlavička Reply-to */
	private InternetAddress odpovedetKomu;

	public String getPredmet() {
		return predmet;
	}

	public void setPredmet(String predmet) {
		this.predmet = predmet;
	}

	public InternetAddress getOdesilatel() {
		return odesilatel;
	}

	public void setOdesilatel(InternetAddress odesilatel) {
		this.odesilatel = odesilatel;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public ArrayList<InternetAddressKomu> getPrijemci() {
		return prijemci;
	}

	/**
	 * @param prijemci pokud je null, nastaví prázdná kolekce.
	 */
	public void setPrijemci(ArrayList<InternetAddressKomu> prijemci) {
		this.prijemci = new ArrayList<InternetAddressKomu>();
		pridejPrijemce(prijemci);
	}

	public void pridejPrijemce(Collection<InternetAddressKomu> prijemci) {
		if (prijemci == null) {
			log.log(Level.FINER, "Prázdná množina příjemců – nic nepřidáme");
		} else {
			this.prijemci.addAll(prijemci);
		}
	}

	/**
	 * Pokud má zpráva více přijemců, než je limit povolený SMTP serverem,
	 * rozdělí se zpráva na více dílčích zpráv.
	 *
	 * @param limit maximální počet příjemců jedné zprávy (omezení SMTP serveru)
	 */
	public Collection<HromadnaZprava> getDilciZpravy(int limit) {
		Collection<HromadnaZprava> zpravy = new ArrayList<HromadnaZprava>();

		if (limit < getPrijemci().size()) {
			/** Zprávu je potřeba rozdělit */
			try {
				HromadnaZprava dilciZprava = (HromadnaZprava) clone();
				dilciZprava.setPrijemci(null);

				ArrayList<InternetAddressKomu> vsichniPrijemci = getPrijemci();
				for (InternetAddressKomu prijemce : vsichniPrijemci) {
					dilciZprava.getPrijemci().add(prijemce);

					if (dilciZprava.getPrijemci().size() == limit) {
						zpravy.add(dilciZprava);
						dilciZprava = (HromadnaZprava) clone();
						dilciZprava.setPrijemci(null);
					}
				}

				if (dilciZprava.getPrijemci().size() > 0) {
					/**
					 * Počet příjemců není násobkem limitu,
					 * takže nakonci ještě někteří zbyli.
					 * Z nich budou příjemci pro poslední dílčí zprávu.
					 */
					zpravy.add(dilciZprava);
				}


			} catch (CloneNotSupportedException ex) {
				/** Tohle by nikdy nemělo nastat */
				log.log(Level.SEVERE, "Hromandou zprávu se nepodařilo naklonovat - divné.", ex);
				zpravy.add(this);
			}
		} else {
			/** Zprávu má málo příjemců - můžeme ji odeslat najednou */
			zpravy.add(this);
		}

		return zpravy;
	}

	public FORMÁT getFormát() {
		return formát;
	}

	public void setFormatHTML(FORMÁT formát) {
		this.formát = formát;
	}

	public InternetAddress getOdpovedetKomu() {
		return odpovedetKomu;
	}

	/** Pokud je null, hlavička Reply-to se v e-mailu vůbec nenastaví. */
	public void setOdpovedetKomu(InternetAddress odpovedetKomu) {
		this.odpovedetKomu = odpovedetKomu;
	}
}
