<?xml version="1.0" encoding="UTF-8"?>
<!--
	Převzato z projektu hellDesk.
-->
<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/xpath-functions"
				xmlns:str="http://xsltsl.org/string"
				xmlns:h="http://www.w3.org/1999/xhtml">
	<xsl:output method="text" encoding="UTF-8"/>
	<xsl:strip-space elements="*"/>

	<xsl:output method="text" encoding="UTF-8"/>
	<xsl:strip-space elements="*"/>

	<xsl:variable name="urlBase" select="/h:html/h:head/h:base/@href"/>


	<!-- Celý dokument -->
	<xsl:template match="/">
		<xsl:apply-templates select="h:html/h:body"/>
	</xsl:template>


	<xsl:template match="h:h1">
		<xsl:value-of select="text()"/>
		<xsl:text>&#10;</xsl:text>
		<xsl:call-template name="str:generate-string">
			<xsl:with-param name="text" select="'='"/>
			<xsl:with-param name="count" select="string-length(.)"/>
		</xsl:call-template>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:h2">
		<xsl:value-of select="text()"/>
		<xsl:text>&#10;</xsl:text>
		<xsl:call-template name="str:generate-string">
			<xsl:with-param name="text" select="'-'"/>
			<xsl:with-param name="count" select="string-length(.)"/>
		</xsl:call-template>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:h3">
		<xsl:text>### </xsl:text>
		<xsl:value-of select="text()"/>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:h4">
		<xsl:text>#### </xsl:text>
		<xsl:value-of select="text()"/>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:h5">
		<xsl:text>##### </xsl:text>
		<xsl:value-of select="text()"/>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:h6">
		<xsl:text>###### </xsl:text>
		<xsl:value-of select="text()"/>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:p">
		<xsl:apply-templates/>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>

	
	<xsl:template match="h:blockquote/h:p">
		<xsl:text>&gt; </xsl:text>
		<xsl:apply-templates/>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:cite[not(starts-with(., '„') or starts-with(., '‚'))]">
		<xsl:text>„</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>“</xsl:text>
	</xsl:template>	


	<xsl:template match="h:a">
		<xsl:if test="not(text() = @href)">
			<xsl:text>'</xsl:text>
			<xsl:apply-templates select="node()"/>
			<xsl:text>' </xsl:text>
		</xsl:if>
		<xsl:text>&lt;</xsl:text>
		<xsl:choose>
			<xsl:when test="starts-with(@href, 'http:') or starts-with(@href, 'https:') or starts-with(@href, 'ftp:')">
				<xsl:value-of select="@href"/>
			</xsl:when>
			<xsl:when test="starts-with(@href, 'mailto:')">
				<xsl:value-of select="substring-after(@href, 'mailto:')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<!-- TODO: $urlBase by nemělo končit lomítkem -->
					<xsl:when test="starts-with(@href, '/')">
						<xsl:value-of select="concat($urlBase, @href)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($urlBase, '/', @href)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>&gt;</xsl:text>
		<xsl:if test="normalize-space(@title)">
			<xsl:text> (</xsl:text>
			<xsl:value-of select="@title"/>
			<xsl:text>)</xsl:text>
		</xsl:if>
	</xsl:template>


	<xsl:template match="h:img">
		<xsl:text>Obrázek: </xsl:text>
		<xsl:value-of select="@src"/>
		<!-- TODO: relativní odkazy -->
	</xsl:template>


	<xsl:template match="h:strong|h:b">
		<xsl:text>**</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>**</xsl:text>
	</xsl:template>


	<xsl:template match="h:em|h:i">
		<xsl:text>*</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>*</xsl:text>
	</xsl:template>


	<xsl:template match="h:abbr[@title]">
		<xsl:apply-templates/>
		<xsl:text> (</xsl:text>
		<xsl:value-of select="@title"/>
		<xsl:text>)</xsl:text>
	</xsl:template>


	<xsl:template match="h:pre">
		<xsl:text>--------------------------------</xsl:text>
		<xsl:text>&#10;</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>--------------------------------</xsl:text>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:code">
		<xsl:text>`</xsl:text>
		<xsl:apply-templates/>
		<xsl:text>`</xsl:text>
	</xsl:template>


	<xsl:template match="h:hr">
		<xsl:text>----------------------------------------------------------------</xsl:text>
		<xsl:text>&#10;</xsl:text>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>


	<xsl:template match="h:br">
		<xsl:text>&#10;</xsl:text>
	</xsl:template>	


	<xsl:template match="h:ol|h:ul">
		<xsl:variable name="úroveň" select="count(ancestor::h:li)"/>
		<xsl:variable name="odsazení">
			<!-- položky na nejvyšší úrovni odsazené jednou mezerou -->
			<xsl:value-of select="' '"/>
			<xsl:call-template name="str:generate-string">
				<xsl:with-param name="text" select="'  '"/>
				<!-- položky na druhé a vyšší úrovni odsazené vždy dvěma dalšími mezerami -->
				<xsl:with-param name="count" select="$úroveň - 1"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:if test="$úroveň &gt; 0">
			<xsl:text>&#10;</xsl:text>
		</xsl:if>

		<xsl:for-each select="h:li">
			<xsl:if test="parent::h:ol">
				<xsl:value-of select="concat($odsazení, position(), ') ')"/>
			</xsl:if>
			<xsl:if test="parent::h:ul">
				<xsl:value-of select="concat($odsazení, '- ')"/>
			</xsl:if>
			<xsl:apply-templates/>
			<xsl:if test="$úroveň = 0 or not(position() = last())">
				<xsl:text>&#10;</xsl:text>
			</xsl:if>
		</xsl:for-each>
		
		<xsl:if test="$úroveň = 0">
			<xsl:text>&#10;</xsl:text>
		</xsl:if>
	</xsl:template>


	<xsl:template match="text()[not(parent::h:pre)]">
		<xsl:if test="(starts-with(., ' ') or starts-with(., '&#10;')) and preceding-sibling::node() and not(preceding-sibling::h:br)">
			<xsl:text> </xsl:text>
		</xsl:if>
		<xsl:value-of select="normalize-space(.)"/>
		<xsl:variable name="posledníZnak" select="substring(., string-length(.))"/>
		<!-- TODO: tabulátor? -->
		<xsl:if test="($posledníZnak = ' ' or $posledníZnak = '&#10;') and following-sibling::node()">
			<xsl:text> </xsl:text>
		</xsl:if>
	</xsl:template>
	
	
	<xsl:template match="h:div[@class = 'patička']">
		<xsl:text>-- </xsl:text>
		<xsl:text>&#10;</xsl:text>
		<xsl:apply-templates/>
	</xsl:template>
	

	<!--
		Převzato z:
		http://xsltsl.sourceforge.net/string.html#template.str:generate-string
	-->
	<xsl:template name="str:generate-string">
		<xsl:param name="text"/>
		<xsl:param name="count"/>

		<xsl:choose>
			<xsl:when test="string-length($text) = 0 or $count &lt;= 0"/>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
				<xsl:call-template name="str:generate-string">
					<xsl:with-param name="text" select="$text"/>
					<xsl:with-param name="count" select="$count - 1"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


</xsl:stylesheet>

