package cz.frantovo.postak.hack;

import cz.frantovo.postak.HromadnaZprava;
import cz.frantovo.postak.InternetAddressKomu;
import cz.frantovo.postak.Nastaveni;
import cz.frantovo.postak.Postak;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.mail.internet.InternetAddress;

/**
 * <p>
 * Toto je jakýsi „skript“ pro zvláštní případy, kdy potřebujeme poslat hromadný e-mail,
 * ale každý příjemce má dostat jiný text. 
 * Resp. text každého e-mailu je parametrizován – dosazením jedné hodnoty za zástupný symbol.
 * </p>
 *
 * <p>
 * Text zprávy načteme ze souboru, stejně jako seznam příjemců a příslušných parametrů.
 * Ostatní údaje se nastavují pomocí konstant níže.
 * </p>
 *
 * <p>
 * Nápady na vylepšení (TODO):
 * </p>
 * <ul>
 * <li>Umožnit zadat více než jeden parametr</li>
 * <li>Načítat nastavení (server, port atd.) ze souboru (jako to dělá SuperPošťák)</li>
 * <li>Zapracovat do GUI SuperPošťáka</li>
 * </ul>
 *
 * <p>
 * Pozor na poměrně intenzivní SMTP komunikaci – posílá se tolik e-mailů, kolik je příjemců,
 * ne jako u klasických hromadných zpráv, kde e-mail má řádové 500 nebo 1000 příjemců
 * (a rozdělí se až na serveru).
 * </p>
 */
public class Individuální {

	private static final String SERVER = "localhost";
	private static final int PORT = 2525;
	/** Soubor obsahující text e-mailu */
	private static final String TEXT_EMAILU = "/tmp/email.txt";
	/** Slovo v textu zprávy, které bude nahrazeno parametrem */
	private static final String TEXT_EMAILU_ZÁSTUPNÝ_SYMBOL = "<nahradit>";
	/** Soubor obsahující seznam příjemců (e-mailových adres) a parametrů, které se dosadí do textu */
	private static final String PŘÍJEMCI = "/tmp/emaily.csv";
	private static final String PŘÍJEMCI_ODDĚLOVAČ = "\t";
	private static final String PŘEDMĚT = "Předmět e-mailu";
	private static final String ODESÍLATEL_ADRESA = "test@example.com";
	private static final String ODESÍLATEL_JMÉNO = "Jméno Příjmení";



	public static void main(String[] args) throws Exception {
		/** Inicializace nastavení a pošťáka */
		Nastaveni nastavení = new Nastaveni();
		nastavení.setPostovniServer(SERVER);
		nastavení.setPostovniPort(PORT);
		Postak pošťák = new Postak(nastavení);

		/** Načteme text zprávy ze souboru */
		BufferedReader emailTxt = new BufferedReader(new FileReader(TEXT_EMAILU));
		StringBuilder text = new StringBuilder();
		while (emailTxt.ready()) {
			text.append(emailTxt.readLine());
			text.append("\n");
		}

		/** Načteme příjemce a jejich parametry ze souboru… */
		BufferedReader příjemci = new BufferedReader(new FileReader(PŘÍJEMCI));
		while (příjemci.ready()) {
			String[] řádka = příjemci.readLine().split(PŘÍJEMCI_ODDĚLOVAČ);
			String email = řádka[0];
			String kód = řádka[1];
			/** …a pošleme jim e-mail */
			odešliEmail(pošťák, text.toString(), email, kód);
		}
	}

	private static void odešliEmail(Postak pošťák, String textZprávy, String emailPříjemce, String parametr) throws Exception {
		System.out.println("Posíláme e-mail – příjemce: " + emailPříjemce + " + parametr: " + parametr);
		HromadnaZprava zpráva = new HromadnaZprava();
		zpráva.setPredmet(PŘEDMĚT);
		zpráva.setOdesilatel(new InternetAddress(ODESÍLATEL_ADRESA, ODESÍLATEL_JMÉNO));
		zpráva.getPrijemci().add(new InternetAddressKomu(emailPříjemce, null));
		/** Parametrizujeme text zprávy */
		textZprávy = textZprávy.replaceAll(TEXT_EMAILU_ZÁSTUPNÝ_SYMBOL, parametr);
		zpráva.setText(textZprávy);
		pošťák.odesli(zpráva);
	}
}
