package cz.frantovo.superPostak;

import cz.frantovo.gui.tabulky.TableSorterModel;
import cz.frantovo.postak.InternetAddressKomu;
import cz.frantovo.postak.Nastaveni;
import cz.frantovo.postak.Postak;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFileChooser;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 *
 * @author  fiki
 */
public class PanelPrijemcu extends javax.swing.JPanel {

    private static final Logger log = Logger.getLogger(PanelPrijemcu.class.getName());
    private static final long serialVersionUID = -8981943048392428523L;
    private ModelTabulky data = new ModelTabulky();
	private Nastaveni nastaveni = new Nastaveni();

    /** Creates new form PanelPrijemcu */
    public PanelPrijemcu() {
        initComponents();
        tabulka.setModel(data);
        tabulka.setSelectionMode(DefaultListSelectionModel.SINGLE_SELECTION);
    }

    public ArrayList<InternetAddressKomu> getAdresy() {
        /** TODO: vracet kopii? */
        return data.data;
    }

	public void setNastaveni(Nastaveni nastaveni) {
		this.nastaveni = nastaveni;
	}

    /** 
     * @param prijemci pokud je null, nastaví prázdná kolekce.
     */
    public void setAdresy(Collection<InternetAddressKomu> adresy) {
        data.data = new ArrayList<InternetAddressKomu>();
        pridejAdresu(adresy);
    }

    public void pridejAdresu(Collection<InternetAddressKomu> adresy) {
        if (adresy == null) {
            log.log(Level.FINER, "Prázdná množina adres - nic nepřidáme");
        } else {
            data.data.addAll(adresy);
            data.upozorniPosluchace();
        }
    }

    /**
     * Pokud je needitovatelný, nelze měnit data v tabuce
     * a z tlačítek je povoleno pouze tlačítko pro uložení do souboru.
     */
    public void setEditovatelny(boolean editovatelny) {
        otevrit.setEnabled(editovatelny);
        pridat.setEnabled(editovatelny);
        odebrat.setEnabled(editovatelny);
        tabulka.setEnabled(editovatelny);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        tabulka = new cz.frantovo.gui.tabulky.JTable();
        pridat = new javax.swing.JButton();
        odebrat = new javax.swing.JButton();
        ulozit = new javax.swing.JButton();
        otevrit = new javax.swing.JButton();

        tabulka.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(tabulka);

        pridat.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/vlozit.png"))); // NOI18N
        pridat.setMnemonic('i');
        pridat.setText("Přidat");
        pridat.setToolTipText("<html>\nPřidá prázdný řádek pro vložení nového příjemce<br/>\nAby se napsaná změna projevila, je potřeba kliknout jinam do tabulky<br/>\n(tzn. ukončit režim editace buňky)<br/>\n</html>");
        pridat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pridatActionPerformed(evt);
            }
        });

        odebrat.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/editdelete.png"))); // NOI18N
        odebrat.setMnemonic('r');
        odebrat.setText("Odebrat");
        odebrat.setToolTipText("Odebere vybraného příjemce");
        odebrat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                odebratActionPerformed(evt);
            }
        });

        ulozit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/ulozit.png"))); // NOI18N
        ulozit.setToolTipText("Uložit seznam příjemců do souboru.");
        ulozit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ulozitActionPerformed(evt);
            }
        });

        otevrit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/otevrit.png"))); // NOI18N
        otevrit.setToolTipText("<html>Přidat příjemce ze souboru.<br/>Na každém řádku se očekává jedna adresa.</html>");
        otevrit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                otevritActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(97, Short.MAX_VALUE)
                .addComponent(otevrit)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ulozit)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(odebrat)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pridat)
                .addContainerGap())
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 410, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 253, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(pridat)
                    .addComponent(odebrat)
                    .addComponent(ulozit)
                    .addComponent(otevrit))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    private void pridatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pridatActionPerformed
        data.pridejRadek();
    }//GEN-LAST:event_pridatActionPerformed

    private void odebratActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_odebratActionPerformed
        int radkaV = tabulka.getSelectedRow();
        int radka = ((TableSorterModel) tabulka.getModel()).modelIndex(radkaV);
        if (radka > -1 && radka < data.getRowCount()) {
            data.odeberRadek(radka);
        }
    }//GEN-LAST:event_odebratActionPerformed

    private void ulozitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ulozitActionPerformed
        JFileChooser dialog = new JFileChooser();
        dialog.setMultiSelectionEnabled(false);
        dialog.setDialogTitle("Uložit seznam do souboru");
		dialog.setCurrentDirectory(new File(nastaveni.getPracovniAdresar()));
        int vysledek = dialog.showSaveDialog(this);
        if (vysledek == JFileChooser.APPROVE_OPTION) {
            File soubor = dialog.getSelectedFile();
			nastaveni.setPracovniAdresar(soubor.getParent());
            try {
                setCursor(new Cursor(Cursor.WAIT_CURSOR));
                OutputStreamWriter zapisovac = new FileWriter(soubor);
                int pocetDobrych = 0;
                int pocetPreskocenych = 0;

                for (InternetAddressKomu adresa : data.data) {
                    /** TODO: různé formátování, případně jména */
                    if (Postak.zkontrolujAdresu(adresa.getAddress())) {
                        zapisovac.write(adresa.getAddress() + "\n");
                        pocetDobrych++;
                    } else {
                        pocetPreskocenych++;
                    }
                }

                zapisovac.close();
                String preskocene = "";
                if (pocetPreskocenych > 0) {
                    preskocene = "\nPočet přeskočených: " + pocetPreskocenych + "\n(Přeskočené neodpovídaly regulárnímu výrazu.)";

                }
                SuperPostak.zobrazInformacniDialog(this, "Uložení seznamu", "Adresy příjemců byly úspěšně uloženy do souboru:\n" + soubor.getAbsolutePath() + "\nPočet uložených adres: " + pocetDobrych + preskocene, true);
            } catch (Exception e) {
                SuperPostak.zobrazChybovyDialog(this, "Uložení seznamu selhalo", "Adresy se nepodařilo uložit do souboru.", null, e, Level.WARNING, false);
            } finally {
                setCursor(Cursor.getDefaultCursor());
            }
        }
    }//GEN-LAST:event_ulozitActionPerformed

    private void otevritActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_otevritActionPerformed
        JFileChooser dialog = new JFileChooser();
        dialog.setMultiSelectionEnabled(false);
        dialog.setDialogTitle("Načíst adresy ze souboru");
		dialog.setCurrentDirectory(new File(nastaveni.getPracovniAdresar()));
        int vysledek = dialog.showOpenDialog(this);
        if (vysledek == JFileChooser.APPROVE_OPTION) {
            File soubor = dialog.getSelectedFile();
			nastaveni.setPracovniAdresar(soubor.getParent());
            try {
                setCursor(new Cursor(Cursor.WAIT_CURSOR));
                BufferedReader ctenar = new BufferedReader(new FileReader(soubor));
                int pocetDobrych = 0;
                int pocetPreskocenych = 0;
                String radka = ctenar.readLine();
                ArrayList<InternetAddressKomu> adresy = new ArrayList<InternetAddressKomu>();

                while (radka != null) {
                    if (Postak.zkontrolujAdresu(radka)) {
                        adresy.add(new InternetAddressKomu(radka, null));
                        pocetDobrych++;

                    } else {
                        pocetPreskocenych++;
                    }

                    radka = ctenar.readLine();
                }

                setAdresy(adresy);
                ctenar.close();
                String preskocene = "";
                if (pocetPreskocenych > 0) {
                    preskocene = "\nPočet přeskočených: " + pocetPreskocenych + "\n(Přeskočené neodpovídaly regulárnímu výrazu.)";

                }

                SuperPostak.zobrazInformacniDialog(this, "Načtení adres", "Byl načten seznam adres ze souboru:\n" + soubor.getAbsolutePath() + "\nPočet načtených adres: " + pocetDobrych + preskocene, true);
            } catch (Exception e) {
                SuperPostak.zobrazChybovyDialog(this, "Načtení souboru selhalo", "Nepodařilo se načíst soubor s adresami.", null, e, Level.WARNING, false);
            } finally {
                setCursor(Cursor.getDefaultCursor());
            }

        }
    }//GEN-LAST:event_otevritActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton odebrat;
    private javax.swing.JButton otevrit;
    private javax.swing.JButton pridat;
    private cz.frantovo.gui.tabulky.JTable tabulka;
    private javax.swing.JButton ulozit;
    // End of variables declaration//GEN-END:variables

    private class ModelTabulky implements TableModel {

        private String[] sloupecky = {"Jméno", "e-mail"};
        private ArrayList<InternetAddressKomu> data = new ArrayList<InternetAddressKomu>();
        private HashSet<TableModelListener> posluchace = new HashSet<TableModelListener>();

        public int getRowCount() {
            return data.size();
        }

        public int getColumnCount() {
            return sloupecky.length;
        }

        public String getColumnName(int n) {
            return sloupecky[n];
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int m, int n) {
            return true;
        }

        public Object getValueAt(int m, int n) {
            if (n == 0) {
                return data.get(m).getPersonal();
            } else if (n == 1) {
                return data.get(m).getAddress();
            } else {
                return null;
            }
        }

        public void setValueAt(Object value, int m, int n) {
            if (n == 0) {
                try {
                    data.get(m).setPersonal(String.valueOf(value.toString()));
                } catch (Exception ex) {
                    log.log(Level.SEVERE, "ModelTabulky.setValueAt(" + m + ", " + n + ")", ex);
                }
            } else if (n == 1) {
                data.get(m).setAddress(String.valueOf(value.toString()));
            }
        }

        public void addTableModelListener(TableModelListener l) {
            posluchace.add(l);
        }

        public void removeTableModelListener(TableModelListener l) {
            posluchace.remove(l);
        }

        public void pridejRadek() {
            data.add(new InternetAddressKomu());

            upozorniPosluchace();
        }

        public void odeberRadek(int m) {
            data.remove(m);
            upozorniPosluchace();
        }

        private void upozorniPosluchace() {
            for (TableModelListener p : posluchace) {
                p.tableChanged(new TableModelEvent(this));
            }
        }
    }
}
