package cz.frantovo.superPostak;

import cz.frantovo.postak.HromadnaZprava;
import cz.frantovo.postak.InternetAddressKomu;
import cz.frantovo.postak.Nastaveni;
import cz.frantovo.postak.Postak;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog.ModalityType;
import java.awt.KeyboardFocusManager;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.error.ErrorInfo;

/**
 *
 * @author  fiki
 */
public class SuperPostak extends javax.swing.JFrame {

    /** Soubor, kde je uložené nastavení */
    private static final String NASTAVENI_SOUBOR = "Nastaveni.xml.gz";
    private static final String CERTIFIKATY_SOUBOR = "DuveryhodneCertifikaty.keystore";
    private static final String NASTAVENI_SLOZKA = ".SuperPostak";
    private static final String DOMACI_ADRESAR = System.getProperty("user.home");
    private static Logger log = Logger.getLogger(SuperPostak.class.getName());
    private static final long serialVersionUID = -7026850569575604048L;
    private Nastaveni nastaveni = new Nastaveni();
    private Postak postak = new Postak(nastaveni);

    /**
     * Creates new form SuperPostak
     * @param ladit předvyplní testovací hodnoty - zprávu
     * @param exit při zavření okna ukončí program     
     */
    public SuperPostak(boolean ladit, boolean exit) {
        log.log(Level.WARNING, "Program byl spuštěn.");
        nactiOvladaceJDBC();
        vytvorSlozkuProgramu();
        initComponents();

        nactiNastaveni();
        ulozNastaveni();
        nastaveni.setCestaKCertifikatum(getCestaKCertifikatum());

        inicializujCardLayout();
        setLocationRelativeTo(null);

		/** Kvůli souborovým dialogům – aby se otvírali ve stejné složce jako minule. */
		prijemciDodatecni.setNastaveni(nastaveni);
		prijemciVychozi.setNastaveni(nastaveni);
		prijemciZkusebni.setNastaveni(nastaveni);

        /** Vyřešíme problém TAB vs. Focus */
        vyresitTabFocusProblem(vstupSQL);
        vyresitTabFocusProblem(vstupZprava);

        /** Ladicí hodnoty */
        if (ladit) {
            nastavLadiciHodnoty();
        }

        if (exit) {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
        }


    }

    private void inicializujCardLayout() {
        panelDatabaze.setName("panelDatabaze");
        panelOdeslat.setName("panelOdeslat");
        panelPrijemci.setName("panelPrijemci");
        panelServer.setName("panelServer");
        panelVychoziPrijemci.setName("panelVychoziPrijemci");
        panelZprava.setName("panelZprava");

        panel.add(panelDatabaze, panelDatabaze.getName());
        panel.add(panelOdeslat, panelOdeslat.getName());
        panel.add(panelPrijemci, panelPrijemci.getName());
        panel.add(panelServer, panelServer.getName());
        panel.add(panelVychoziPrijemci, panelVychoziPrijemci.getName());
        panel.add(panelZprava, panelZprava.getName());

        setPanel(panelZprava);
        pack();
    }

    /**
     * Vyplní formuláře (odesílatel, předmět, zpráva, příjemci...) výchozími hodnotami,
     * aby se dal program testovat jedním kliknutím.
     */
    private void nastavLadiciHodnoty() {
        try {
            vstupAdresaOdesilatele.setText("SuperPostak@frantovo.cz");
            vstupJmenoOdesilatele.setText("SuperPošťák");
            vstupPredmet.setText("Zkušební zpráva od SuperPošťáka");
            vstupZprava.setText("Toto je obyčejná zkušební zpráva v češtině :-)");
            ArrayList<InternetAddressKomu> adresy = new ArrayList<InternetAddressKomu>();
            adresy.add(new InternetAddressKomu("SuperPostak@frantovo.cz", "SuperPošťák"));
            prijemciZkusebni.setAdresy(adresy);
        } catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, null, e);
        }
    }

    /**
     * Pokusíme se načíst ovladače pro různé DB a výsledek zapíšeme do logu.
     * Další ovladače je možné přidat pomocí manifestu v příslušných knihovnách.
     * viz http://www.sweb.cz/pichlik/archive/2006_08_06_archive.html#115502885631518161
     */
    private void nactiOvladaceJDBC() {
        nactiOvladacJDBC("org.postgresql.Driver", "PostgreSQL");
        nactiOvladacJDBC("com.mysql.jdbc.Driver", "MySQL");
        nactiOvladacJDBC("net.sourceforge.jtds.jdbc.Driver", "jTDS Sybase a MS SQL");
        nactiOvladacJDBC("com.sybase.jdbc2.jdbc.SybDriver", "Sybase.com");
        nactiOvladacJDBC("oracle.jdbc.OracleDriver", "Oracle");
    }

    /**
     * @param trida ovladač databáze, který se má načíst
     * @param jmeno název databáze     
     */
    private void nactiOvladacJDBC(String trida, String jmeno) {
        try {
            Class.forName(trida);
            log.log(Level.INFO, "JDBC ovladač pro " + jmeno + " byl úspěšně načten.");
        } catch (ClassNotFoundException e) {
            log.log(Level.INFO, "JDBC ovladač pro " + jmeno + " se nepodařilo načíst.");
        }
    }

    /** Vrací plnou cestu k souboru s nastavením */
    protected static String getCestaKCertifikatum() {
        return getCestaKeSlozceProgramu() + CERTIFIKATY_SOUBOR;
    }

    /** Vrací plnou cestu k souboru s nastavením */
    protected static String getCestaKNastaveni() {
        return getCestaKeSlozceProgramu() + NASTAVENI_SOUBOR;
    }

    /** Vrací plnou cestu ke složce programu (nastavení, certifikáty a logy) */
    protected static String getCestaKeSlozceProgramu() {
        return DOMACI_ADRESAR + File.separator + NASTAVENI_SLOZKA + File.separator;
    }

    /** Načte nastavení ze souboru */
    private void nactiNastaveni() {
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new GZIPInputStream(new FileInputStream(getCestaKNastaveni()))));
            Object xmlObjekt = d.readObject();
            d.close();

            if (xmlObjekt instanceof Nastaveni) {
                nastaveni = (Nastaveni) xmlObjekt;
            } else {
                nastaveni = new Nastaveni();
                log.log(Level.SEVERE, "Nepodařilo se načíst nastavení: není instancí");
            }

            nactiNastaveniGUI();

            log.log(Level.INFO, "Nastavení bylo načteno.");
        } catch (FileNotFoundException ex) {
            log.log(Level.SEVERE, "Nepodařilo se načíst nastavení: soubor nenalezen", ex);
        } catch (IOException ex) {
            log.log(Level.SEVERE, "Nastavení se nepodařilo načíst: I/O.", ex);
        }
    }

    /** Vytvoří (pokud neexistuje) v domovském adresáři složku, kam se ukládá nastavení a případně logy */
    private static boolean vytvorSlozkuProgramu() {
        if (new File(getCestaKeSlozceProgramu()).mkdirs()) {
            log.log(Level.INFO, "Složka pro nastavení programu byla vytvořena: " + getCestaKeSlozceProgramu());
            return true;
        } else {
            return false;
        }
    }

    /** Uloží nastavení do souboru */
    private void ulozNastaveni() {
        try {
            ulozNastaveniGUI();

            vytvorSlozkuProgramu();

            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(getCestaKNastaveni()))));
            e.writeObject(nastaveni);
            e.close();
            log.log(Level.INFO, "Nastavení bylo uloženo.");
        } catch (FileNotFoundException ex) {
            log.log(Level.SEVERE, "Nastavení se nepodařilo uložit: soubor nenalezen.", ex);
        } catch (IOException ex) {
            log.log(Level.SEVERE, "Nastavení se nepodařilo uložit: I/O.", ex);
        }
    }

    /** Posbírá zadané hodnoty z GUI a uloží je do objektu nastaveni */
    private void ulozNastaveniGUI() {
        nastaveni.setDatabaze(vstupDatabaze.getText());
        nastaveni.setDbHeslo(vstupDBheslo.getPassword());
        nastaveni.setDbJmeno(vstupDBjmeno.getText());
        nastaveni.setLimitZprav((Integer) vstupSMTPlimitPrijemcu.getValue());
        nastaveni.setPostovniHeslo(vstupSMTPheslo.getPassword());
        nastaveni.setPostovniJmeno(vstupSMTPjmeno.getText());
        nastaveni.setPostovniPort((Integer) vstupSMTPport.getValue());
        nastaveni.setPostovniServer(vstupSMTPserver.getText());
        nastaveni.setVychoziPrijemci(prijemciVychozi.getAdresy());
    }

    /** Aktualizuje GUI formuláře hodnotami z objektu nastaveni */
    private void nactiNastaveniGUI() {
        vstupDatabaze.setText(nastaveni.getDatabaze());
        if (nastaveni.getDbHeslo() != null) {
            vstupDBheslo.setText(String.valueOf(nastaveni.getDbHeslo()));
        }
        vstupDBjmeno.setText(nastaveni.getDbJmeno());
        vstupSMTPlimitPrijemcu.setValue(nastaveni.getLimitZprav());
        if (nastaveni.getPostovniHeslo() != null) {
            vstupSMTPheslo.setText(String.valueOf(nastaveni.getPostovniHeslo()));
        }
        vstupSMTPjmeno.setText(nastaveni.getPostovniJmeno());
        vstupSMTPport.setValue(nastaveni.getPostovniPort());
        vstupSMTPserver.setText(nastaveni.getPostovniServer());
        prijemciVychozi.setAdresy(nastaveni.getVychoziPrijemci());
    }

    protected static void zobrazChybovyDialog(Component vlastnik, String strucnaZprava, Throwable vyjimka, Level zavaznost, boolean logovat) {
        zobrazChybovyDialog(vlastnik, "Chyba", strucnaZprava, null, vyjimka, zavaznost, logovat);
    }

    protected static void zobrazInformacniDialog(Component vlastnik, String nadpis, String text, boolean loguj) {
        JOptionPane.showMessageDialog(vlastnik, text, nadpis, JOptionPane.INFORMATION_MESSAGE);
        if (loguj) {
            log.log(Level.INFO, nadpis + ": " + text);
        }
    }

    protected static void zobrazChybovyDialog(Component vlastnik, String nadpis, String strucnaZprava, String podrobnaZprava, Throwable vyjimka, Level zavaznost, boolean logovat) {
        if (logovat) {
            log.log(zavaznost, strucnaZprava, vyjimka);
        }

        JXErrorPane chybovyPanel = new JXErrorPane();
        ErrorInfo chybovaInformace = new ErrorInfo(nadpis, strucnaZprava, podrobnaZprava, null, vyjimka, zavaznost, null);
        chybovyPanel.setErrorInfo(chybovaInformace);
        JDialog dialog = JXErrorPane.createDialog(vlastnik, chybovyPanel);
        dialog.setVisible(true);
    }

    private void zobrazChybovyDialog(String strucnaZprava, Throwable vyjimka, Level zavaznost, boolean logovat) {
        zobrazChybovyDialog(this, strucnaZprava, vyjimka, zavaznost, logovat);
    }

    private void zobrazInformacniDialog(String nadpis, String text, boolean loguj) {
        zobrazInformacniDialog(this, nadpis, text, loguj);
    }

    private void zobrazChybovyDialog(String nadpis, String strucnaZprava, String podrobnaZprava, Throwable vyjimka, Level zavaznost, boolean logovat) {
        zobrazChybovyDialog(this, nadpis, strucnaZprava, podrobnaZprava, vyjimka, zavaznost, logovat);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        panelDatabaze = new org.jdesktop.swingx.JXPanel();
        jLabel9 = new javax.swing.JLabel();
        vstupDatabaze = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        vstupDBjmeno = new javax.swing.JTextField();
        vstupDBheslo = new javax.swing.JPasswordField();
        jLabel11 = new javax.swing.JLabel();
        vyzkousetPripojeniTlacitko = new javax.swing.JButton();
        vystupDBzprava = new javax.swing.JLabel();
        panelOdeslat = new org.jdesktop.swingx.JXPanel();
        jPanel1 = new javax.swing.JPanel();
        rozeslatZkusebniTlacitko = new javax.swing.JButton();
        rozeslatHromadnouZpravuTlacitko = new javax.swing.JButton();
        zobrazitVsechnyPrijemceTlacitko = new javax.swing.JButton();
        prijemciZkusebni = new cz.frantovo.superPostak.PanelPrijemcu();
        jSeparator2 = new javax.swing.JSeparator();
        jLabel14 = new javax.swing.JLabel();
        panelPrijemci = new org.jdesktop.swingx.JXPanel();
        jLabel13 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        vstupSQL = new javax.swing.JTextArea();
        vyzkousetSQLTlacitko = new javax.swing.JButton();
        vystupSQLZprava = new javax.swing.JLabel();
        prijemciDodatecni = new cz.frantovo.superPostak.PanelPrijemcu();
        jSeparator1 = new javax.swing.JSeparator();
        jLabel16 = new javax.swing.JLabel();
        zobrazitSQLPrijemceTlacitko = new javax.swing.JButton();
        panelServer = new org.jdesktop.swingx.JXPanel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        vstupSMTPserver = new javax.swing.JTextField();
        vstupSMTPport = new javax.swing.JSpinner();
        napovedaSMTPscroll = new javax.swing.JScrollPane();
        napovedaSMTP = new javax.swing.JTextArea();
        jLabel6 = new javax.swing.JLabel();
        vstupSMTPjmeno = new javax.swing.JTextField();
        vstupSMTPheslo = new javax.swing.JPasswordField();
        jLabel7 = new javax.swing.JLabel();
        vstupSMTPlimitPrijemcu = new javax.swing.JSpinner();
        jLabel8 = new javax.swing.JLabel();
        panelVychoziPrijemci = new org.jdesktop.swingx.JXPanel();
        prijemciVychozi = new cz.frantovo.superPostak.PanelPrijemcu();
        jLabel12 = new javax.swing.JLabel();
        panelZprava = new org.jdesktop.swingx.JXPanel();
        jLabel1 = new javax.swing.JLabel();
        vstupPredmet = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        vstupJmenoOdesilatele = new javax.swing.JTextField();
        vstupAdresaOdesilatele = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        vstupZprava = new javax.swing.JTextArea();
        jLabel15 = new javax.swing.JLabel();
        vstupFormatHTML = new javax.swing.JCheckBox();
        odpovedetKomuOdkaz = new org.jdesktop.swingx.JXHyperlink();
        odpovedetKomuDialog = new javax.swing.JDialog();
        jLabel18 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        jLabel17 = new javax.swing.JLabel();
        odpovedetKomuJmeno = new javax.swing.JTextField();
        odpovedetKomuAdresa = new javax.swing.JTextField();
        odpovedetKomuHotovo = new javax.swing.JButton();
        jXHeader1 = new org.jdesktop.swingx.JXHeader();
        taskPanel = new org.jdesktop.swingx.JXTaskPaneContainer();
        jXTaskPane1 = new org.jdesktop.swingx.JXTaskPane();
        lnText = new org.jdesktop.swingx.JXHyperlink();
        lnPrijemci = new org.jdesktop.swingx.JXHyperlink();
        lnOdeslat = new org.jdesktop.swingx.JXHyperlink();
        jXTaskPane2 = new org.jdesktop.swingx.JXTaskPane();
        lnServer = new org.jdesktop.swingx.JXHyperlink();
        lnDatabaze = new org.jdesktop.swingx.JXHyperlink();
        lnVychoziPrijemci = new org.jdesktop.swingx.JXHyperlink();
        panel = new org.jdesktop.swingx.JXPanel();

        jLabel9.setText("Databáze");

        jLabel10.setText("Jméno");

        jLabel11.setText("Heslo");

        vyzkousetPripojeniTlacitko.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/fork.png"))); // NOI18N
        vyzkousetPripojeniTlacitko.setMnemonic('y');
        vyzkousetPripojeniTlacitko.setText("Vyzkoušet spojení");
        vyzkousetPripojeniTlacitko.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                vyzkousetPripojeniTlacitkoActionPerformed(evt);
            }
        });

        vystupDBzprava.setText(" ");

        javax.swing.GroupLayout panelDatabazeLayout = new javax.swing.GroupLayout(panelDatabaze);
        panelDatabaze.setLayout(panelDatabazeLayout);
        panelDatabazeLayout.setHorizontalGroup(
            panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelDatabazeLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(panelDatabazeLayout.createSequentialGroup()
                        .addGroup(panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel9)
                            .addComponent(jLabel10)
                            .addComponent(jLabel11))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(vstupDatabaze, javax.swing.GroupLayout.DEFAULT_SIZE, 257, Short.MAX_VALUE)
                            .addComponent(vstupDBjmeno, javax.swing.GroupLayout.DEFAULT_SIZE, 257, Short.MAX_VALUE)
                            .addGroup(panelDatabazeLayout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(vstupDBheslo, javax.swing.GroupLayout.DEFAULT_SIZE, 257, Short.MAX_VALUE))))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelDatabazeLayout.createSequentialGroup()
                        .addComponent(vystupDBzprava, javax.swing.GroupLayout.DEFAULT_SIZE, 155, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(vyzkousetPripojeniTlacitko)))
                .addContainerGap())
        );
        panelDatabazeLayout.setVerticalGroup(
            panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelDatabazeLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel9)
                    .addComponent(vstupDatabaze, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel10)
                    .addComponent(vstupDBjmeno, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel11)
                    .addComponent(vstupDBheslo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(panelDatabazeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(vyzkousetPripojeniTlacitko)
                    .addComponent(vystupDBzprava))
                .addContainerGap(183, Short.MAX_VALUE))
        );

        rozeslatZkusebniTlacitko.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/apply.png"))); // NOI18N
        rozeslatZkusebniTlacitko.setMnemonic('u');
        rozeslatZkusebniTlacitko.setText("Rozeslat zkušební");
        rozeslatZkusebniTlacitko.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rozeslatZkusebniTlacitkoActionPerformed(evt);
            }
        });

        rozeslatHromadnouZpravuTlacitko.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/adept_commit.png"))); // NOI18N
        rozeslatHromadnouZpravuTlacitko.setMnemonic('h');
        rozeslatHromadnouZpravuTlacitko.setText("Rozeslat hromadnou zprávu");
        rozeslatHromadnouZpravuTlacitko.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rozeslatHromadnouZpravuTlacitkoActionPerformed(evt);
            }
        });

        zobrazitVsechnyPrijemceTlacitko.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/zobrazit_adresy.png"))); // NOI18N
        zobrazitVsechnyPrijemceTlacitko.setToolTipText("<html>\nZobrazí seznam všech příjemcům, kterým bude odeslána zpráva.<br/>\n(Při velkých počtech záznamů může být tato operace náročná.)\n</html>");
        zobrazitVsechnyPrijemceTlacitko.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zobrazitVsechnyPrijemceTlacitkoActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap(106, Short.MAX_VALUE)
                .addComponent(rozeslatZkusebniTlacitko)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(rozeslatHromadnouZpravuTlacitko)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(zobrazitVsechnyPrijemceTlacitko)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(rozeslatHromadnouZpravuTlacitko)
                    .addComponent(zobrazitVsechnyPrijemceTlacitko)
                    .addComponent(rozeslatZkusebniTlacitko))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel14.setText("Zkušební příjemci");

        javax.swing.GroupLayout panelOdeslatLayout = new javax.swing.GroupLayout(panelOdeslat);
        panelOdeslat.setLayout(panelOdeslatLayout);
        panelOdeslatLayout.setHorizontalGroup(
            panelOdeslatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelOdeslatLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelOdeslatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(prijemciZkusebni, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 535, Short.MAX_VALUE)
                    .addComponent(jSeparator2, javax.swing.GroupLayout.DEFAULT_SIZE, 535, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel14))
                .addContainerGap())
        );
        panelOdeslatLayout.setVerticalGroup(
            panelOdeslatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelOdeslatLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel14)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(prijemciZkusebni, javax.swing.GroupLayout.DEFAULT_SIZE, 153, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jLabel13.setText("SQL dotaz");

        vstupSQL.setColumns(20);
        vstupSQL.setRows(5);
        jScrollPane3.setViewportView(vstupSQL);

        vyzkousetSQLTlacitko.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/fork.png"))); // NOI18N
        vyzkousetSQLTlacitko.setMnemonic('y');
        vyzkousetSQLTlacitko.setText("Vyzkoušet");
        vyzkousetSQLTlacitko.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                vyzkousetSQLTlacitkoActionPerformed(evt);
            }
        });

        vystupSQLZprava.setText(" ");

        prijemciDodatecni.setToolTipText("Zde můžete dopnit další přijemce.");

        jLabel16.setText("Dodateční příjemci:");

        zobrazitSQLPrijemceTlacitko.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/zobrazit_adresy.png"))); // NOI18N
        zobrazitSQLPrijemceTlacitko.setToolTipText("<html>\nZobrazí seznam adres načtených z databáze.<br/>\n(Při velkých počtech záznamů může být tato operace náročná.)\n</html>");
        zobrazitSQLPrijemceTlacitko.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zobrazitSQLPrijemceTlacitkoActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout panelPrijemciLayout = new javax.swing.GroupLayout(panelPrijemci);
        panelPrijemci.setLayout(panelPrijemciLayout);
        panelPrijemciLayout.setHorizontalGroup(
            panelPrijemciLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelPrijemciLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelPrijemciLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(prijemciDodatecni, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 344, Short.MAX_VALUE)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 344, Short.MAX_VALUE)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 344, Short.MAX_VALUE)
                    .addComponent(jLabel13, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(panelPrijemciLayout.createSequentialGroup()
                        .addComponent(vystupSQLZprava, javax.swing.GroupLayout.DEFAULT_SIZE, 52, Short.MAX_VALUE)
                        .addGap(127, 127, 127)
                        .addComponent(vyzkousetSQLTlacitko)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(zobrazitSQLPrijemceTlacitko))
                    .addComponent(jLabel16, javax.swing.GroupLayout.Alignment.LEADING))
                .addContainerGap())
        );
        panelPrijemciLayout.setVerticalGroup(
            panelPrijemciLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelPrijemciLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelPrijemciLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(vystupSQLZprava, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(zobrazitSQLPrijemceTlacitko)
                    .addComponent(vyzkousetSQLTlacitko))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel16)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(prijemciDodatecni, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                .addContainerGap())
        );

        jLabel4.setText("SMTP server");

        jLabel5.setText("Port");

        vstupSMTPserver.setText("localhost");

        vstupSMTPport.setValue(25);

        napovedaSMTP.setColumns(20);
        napovedaSMTP.setEditable(false);
        napovedaSMTP.setLineWrap(true);
        napovedaSMTP.setRows(5);
        napovedaSMTP.setText("Tip: některé SMTP servery mají omezený seznam počítačů, ze kterých přijímají poštu");
        napovedaSMTP.setWrapStyleWord(true);
        napovedaSMTPscroll.setViewportView(napovedaSMTP);

        jLabel6.setText("Jméno");

        jLabel7.setText("Heslo");

        vstupSMTPlimitPrijemcu.setValue(1000);

        jLabel8.setText("Limit příjemců");

        javax.swing.GroupLayout panelServerLayout = new javax.swing.GroupLayout(panelServer);
        panelServer.setLayout(panelServerLayout);
        panelServerLayout.setHorizontalGroup(
            panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelServerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(napovedaSMTPscroll, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 318, Short.MAX_VALUE)
                    .addGroup(panelServerLayout.createSequentialGroup()
                        .addGroup(panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel4)
                            .addComponent(jLabel6)
                            .addComponent(jLabel5)
                            .addComponent(jLabel7)
                            .addComponent(jLabel8))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(vstupSMTPserver, javax.swing.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE)
                            .addComponent(vstupSMTPport, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE)
                            .addComponent(vstupSMTPjmeno, javax.swing.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE)
                            .addComponent(vstupSMTPheslo, javax.swing.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE)
                            .addComponent(vstupSMTPlimitPrijemcu, javax.swing.GroupLayout.DEFAULT_SIZE, 230, Short.MAX_VALUE))))
                .addContainerGap())
        );
        panelServerLayout.setVerticalGroup(
            panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelServerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(vstupSMTPserver, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(vstupSMTPport, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(vstupSMTPjmeno, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(vstupSMTPheslo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel7))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelServerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(vstupSMTPlimitPrijemcu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(napovedaSMTPscroll, javax.swing.GroupLayout.DEFAULT_SIZE, 145, Short.MAX_VALUE)
                .addContainerGap())
        );

        jLabel12.setText("Těmto lidem přijde hromadný e-mail vždy (netýká se zkušebního rozeslání zprávy).");

        javax.swing.GroupLayout panelVychoziPrijemciLayout = new javax.swing.GroupLayout(panelVychoziPrijemci);
        panelVychoziPrijemci.setLayout(panelVychoziPrijemciLayout);
        panelVychoziPrijemciLayout.setHorizontalGroup(
            panelVychoziPrijemciLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelVychoziPrijemciLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelVychoziPrijemciLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(prijemciVychozi, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 514, Short.MAX_VALUE)
                    .addComponent(jLabel12, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 514, Short.MAX_VALUE))
                .addContainerGap())
        );
        panelVychoziPrijemciLayout.setVerticalGroup(
            panelVychoziPrijemciLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelVychoziPrijemciLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel12)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(prijemciVychozi, javax.swing.GroupLayout.DEFAULT_SIZE, 261, Short.MAX_VALUE)
                .addContainerGap())
        );

        jLabel1.setLabelFor(vstupPredmet);
        jLabel1.setText("Předmět");

        vstupPredmet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                vstupPredmetActionPerformed(evt);
            }
        });

        jLabel2.setText("Jméno odesílatele");

        vstupZprava.setColumns(20);
        vstupZprava.setRows(5);
        jScrollPane1.setViewportView(vstupZprava);

        jLabel15.setText("Formát zprávy");

        vstupFormatHTML.setMnemonic('h');
        vstupFormatHTML.setText("HTML");
        vstupFormatHTML.setToolTipText("Při nezaškrtnutí se odešle jako prostý text");

        odpovedetKomuOdkaz.setForeground(javax.swing.UIManager.getDefaults().getColor("windowText"));
        odpovedetKomuOdkaz.setMnemonic('e');
        odpovedetKomuOdkaz.setText("Adresa odesílatele");
        odpovedetKomuOdkaz.setToolTipText("<html><p>Klikněte sem pro nastavení adresy,</p><p>na kterou mají chodit odpovědi</p></html>");
        odpovedetKomuOdkaz.setClickedColor(javax.swing.UIManager.getDefaults().getColor("windowText"));
        odpovedetKomuOdkaz.setUnclickedColor(javax.swing.UIManager.getDefaults().getColor("windowText"));
        odpovedetKomuOdkaz.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                odpovedetKomuOdkazActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout panelZpravaLayout = new javax.swing.GroupLayout(panelZprava);
        panelZprava.setLayout(panelZpravaLayout);
        panelZpravaLayout.setHorizontalGroup(
            panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, panelZpravaLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 438, Short.MAX_VALUE)
                    .addGroup(panelZpravaLayout.createSequentialGroup()
                        .addGroup(panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(panelZpravaLayout.createSequentialGroup()
                                .addGroup(panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel2)
                                    .addComponent(jLabel1))
                                .addGap(17, 17, 17))
                            .addGroup(panelZpravaLayout.createSequentialGroup()
                                .addComponent(odpovedetKomuOdkaz, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)))
                        .addGroup(panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(vstupJmenoOdesilatele, javax.swing.GroupLayout.DEFAULT_SIZE, 328, Short.MAX_VALUE)
                            .addComponent(vstupAdresaOdesilatele, javax.swing.GroupLayout.DEFAULT_SIZE, 328, Short.MAX_VALUE)
                            .addComponent(vstupPredmet, javax.swing.GroupLayout.DEFAULT_SIZE, 328, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, panelZpravaLayout.createSequentialGroup()
                        .addComponent(jLabel15)
                        .addGap(33, 33, 33)
                        .addComponent(vstupFormatHTML, javax.swing.GroupLayout.DEFAULT_SIZE, 81, Short.MAX_VALUE)
                        .addGap(247, 247, 247)))
                .addContainerGap())
        );
        panelZpravaLayout.setVerticalGroup(
            panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelZpravaLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(vstupPredmet, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(vstupJmenoOdesilatele, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(vstupAdresaOdesilatele, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(odpovedetKomuOdkaz, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 184, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panelZpravaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel15)
                    .addComponent(vstupFormatHTML))
                .addContainerGap())
        );

        odpovedetKomuDialog.setTitle("Adresa pro odpovědi");
        odpovedetKomuDialog.setModal(true);

        jLabel18.setText("Jméno");

        jLabel19.setText("Adresa");

        jLabel17.setText("<html>\n<p>Pokud bude příjemce na hromadnou zprávu odpovídat,</p>\n<p>odpověď přijde na tuto adresu.</p>\n<p>Pokud tyto údaje nevyplníte, nebo zadáte chybný e-mail,</p>\n<p>budou odpovědi chodit odesílateli.</p>\n</html>");

        odpovedetKomuHotovo.setText("Hotovo");
        odpovedetKomuHotovo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                odpovedetKomuHotovoActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout odpovedetKomuDialogLayout = new javax.swing.GroupLayout(odpovedetKomuDialog.getContentPane());
        odpovedetKomuDialog.getContentPane().setLayout(odpovedetKomuDialogLayout);
        odpovedetKomuDialogLayout.setHorizontalGroup(
            odpovedetKomuDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(odpovedetKomuDialogLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(odpovedetKomuDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(odpovedetKomuDialogLayout.createSequentialGroup()
                        .addGroup(odpovedetKomuDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel19)
                            .addComponent(jLabel18))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(odpovedetKomuDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(odpovedetKomuAdresa, javax.swing.GroupLayout.DEFAULT_SIZE, 332, Short.MAX_VALUE)
                            .addComponent(odpovedetKomuJmeno, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 332, Short.MAX_VALUE)))
                    .addComponent(jLabel17, javax.swing.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                    .addComponent(odpovedetKomuHotovo, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        odpovedetKomuDialogLayout.setVerticalGroup(
            odpovedetKomuDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(odpovedetKomuDialogLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(odpovedetKomuDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel18)
                    .addComponent(odpovedetKomuJmeno, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(odpovedetKomuDialogLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel19)
                    .addComponent(odpovedetKomuAdresa, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel17)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(odpovedetKomuHotovo)
                .addContainerGap())
        );

        setTitle("SuperPošťák");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jXHeader1.setDescription("Program pro posílání hromadných zpráv elektronickou poštou.\nNezneužívejte pro rozesílání spamu.");
        jXHeader1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/xfmail.png"))); // NOI18N
        jXHeader1.setTitle("SuperPošťák");

        taskPanel.setBackground(javax.swing.UIManager.getDefaults().getColor("Button.background"));

        jXTaskPane1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/mail_generic.png"))); // NOI18N
        jXTaskPane1.setTitle("Hromadná zpráva");

        lnText.setMnemonic('z');
        lnText.setText("Text zprávy");
        lnText.setActionCommand("Zpráva");
        lnText.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lnTextActionPerformed(evt);
            }
        });
        jXTaskPane1.getContentPane().add(lnText);

        lnPrijemci.setMnemonic('p');
        lnPrijemci.setText("Příjemci");
        lnPrijemci.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lnPrijemciActionPerformed(evt);
            }
        });
        jXTaskPane1.getContentPane().add(lnPrijemci);

        lnOdeslat.setMnemonic('o');
        lnOdeslat.setText("Odeslat");
        lnOdeslat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lnOdeslatActionPerformed(evt);
            }
        });
        jXTaskPane1.getContentPane().add(lnOdeslat);

        taskPanel.add(jXTaskPane1);

        jXTaskPane2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cz/frantovo/superPostak/obrazky/gear.png"))); // NOI18N
        jXTaskPane2.setTitle("Nastavení");

        lnServer.setMnemonic('s');
        lnServer.setText("Poštovní server");
        lnServer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lnServerActionPerformed(evt);
            }
        });
        jXTaskPane2.getContentPane().add(lnServer);

        lnDatabaze.setMnemonic('d');
        lnDatabaze.setText("Databáze");
        lnDatabaze.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lnDatabazeActionPerformed(evt);
            }
        });
        jXTaskPane2.getContentPane().add(lnDatabaze);

        lnVychoziPrijemci.setMnemonic('v');
        lnVychoziPrijemci.setText("Výchozí příjemci");
        lnVychoziPrijemci.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lnVychoziPrijemciActionPerformed(evt);
            }
        });
        jXTaskPane2.getContentPane().add(lnVychoziPrijemci);

        taskPanel.add(jXTaskPane2);

        panel.setLayout(new java.awt.CardLayout());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(taskPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 196, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(panel, javax.swing.GroupLayout.DEFAULT_SIZE, 342, Short.MAX_VALUE))
            .addComponent(jXHeader1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 544, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jXHeader1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(taskPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 340, Short.MAX_VALUE)
                    .addComponent(panel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 340, Short.MAX_VALUE)))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void vstupPredmetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_vstupPredmetActionPerformed
}//GEN-LAST:event_vstupPredmetActionPerformed

    private void lnTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lnTextActionPerformed
        setPanel(panelZprava);
    }//GEN-LAST:event_lnTextActionPerformed

    private void lnPrijemciActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lnPrijemciActionPerformed
        setPanel(panelPrijemci);
    }//GEN-LAST:event_lnPrijemciActionPerformed

    private void lnOdeslatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lnOdeslatActionPerformed
        setPanel(panelOdeslat);
    }//GEN-LAST:event_lnOdeslatActionPerformed

    private void lnServerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lnServerActionPerformed
        setPanel(panelServer);
    }//GEN-LAST:event_lnServerActionPerformed

    private void lnDatabazeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lnDatabazeActionPerformed
        setPanel(panelDatabaze);
    }//GEN-LAST:event_lnDatabazeActionPerformed

    private void lnVychoziPrijemciActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lnVychoziPrijemciActionPerformed
        setPanel(panelVychoziPrijemci);
    }//GEN-LAST:event_lnVychoziPrijemciActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        ulozNastaveni();
        log.log(Level.WARNING, "Ukončuji program.");
    }//GEN-LAST:event_formWindowClosing

    /**
     * Sestaví zprávu na základě GUI vstupů. Všechno kromě příjemců,
     * ti se přidají až dodatečně, podle toho,
     * jestli jde o zkušební nebo skutečné rozesílání.
     */
    private HromadnaZprava getZprava() throws UnsupportedEncodingException {
        HromadnaZprava zprava = new HromadnaZprava();
        zprava.setOdesilatel(new InternetAddress(vstupAdresaOdesilatele.getText(), vstupJmenoOdesilatele.getText()));
        zprava.setPredmet(vstupPredmet.getText());
        zprava.setText(vstupZprava.getText());
        zprava.setFormatHTML(vstupFormatHTML.isSelected());

        if (Postak.zkontrolujAdresu(odpovedetKomuAdresa.getText())) {
            InternetAddress komu = new InternetAddress();
            komu.setPersonal(odpovedetKomuJmeno.getText());
            komu.setAddress(odpovedetKomuAdresa.getText());
            zprava.setOdpovedetKomu(komu);
        }

        return zprava;
    }

    /** Všichni příjemci, kterým bude odeslána ostrá zpráva. */
    private ArrayList<InternetAddressKomu> getPrijemciVsichni() throws SQLException, UnsupportedEncodingException {
        ArrayList<InternetAddressKomu> vsichni = new ArrayList<InternetAddressKomu>();
        Collection<InternetAddressKomu> adresyVychozi = nastaveni.getVychoziPrijemci();
        Collection<InternetAddressKomu> adresySQL = getPrijemciSQL();
        Collection<InternetAddressKomu> adresyDodatecne = prijemciDodatecni.getAdresy();

        if (adresyVychozi != null) {
            vsichni.addAll(adresyVychozi);
        }
        if (adresySQL != null) {
            vsichni.addAll(adresySQL);
        }
        if (adresyDodatecne != null) {
            vsichni.addAll(adresyDodatecne);
        }
        return vsichni;
    }

    private void rozeslatHromadnouZpravuTlacitkoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rozeslatHromadnouZpravuTlacitkoActionPerformed
        try {
            ulozNastaveniGUI();
            HromadnaZprava zprava = getZprava();
            zprava.setPrijemci(getPrijemciVsichni());

            int volba = JOptionPane.showOptionDialog(this, "Počet příjemců hromadné zprávy: " + zprava.getPrijemci().size() + "\nPřejete si zprávu odeslat?", "Potvrdit odeslání", JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE, null, null, null);
            if (volba == JOptionPane.YES_OPTION) {
                odesli(zprava);
                Postak.vypisPrijemce(zprava.getPrijemci());
                zobrazInformacniDialog("Odesláno", "Zpráva byla odeslána.\nPočet příjemců: " + zprava.getPrijemci().size(), true);
            }
        } catch (Exception e) {
            zobrazChybovyDialog("Zprávu se nepodařilo odeslat", e, Level.SEVERE, true);
        }
}//GEN-LAST:event_rozeslatHromadnouZpravuTlacitkoActionPerformed

    private void rozeslatZkusebniTlacitkoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rozeslatZkusebniTlacitkoActionPerformed
        try {
            ulozNastaveniGUI();
            HromadnaZprava zprava = getZprava();
            zprava.setPrijemci(prijemciZkusebni.getAdresy());

            odesli(zprava);

            zobrazInformacniDialog("Odesláno", "Zkušební zpráva byla odeslána.\nPočet adresátů: " + zprava.getPrijemci().size(), true);
        } catch (Exception e) {
            zobrazChybovyDialog("Zkušební zprávu se nepodařilo odeslat", e, Level.SEVERE, true);
        }
    }//GEN-LAST:event_rozeslatZkusebniTlacitkoActionPerformed

    private void vyzkousetPripojeniTlacitkoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_vyzkousetPripojeniTlacitkoActionPerformed
        try {
            getSpojeni();//GEN-LAST:event_vyzkousetPripojeniTlacitkoActionPerformed
            zobrazInformacniDialog("Připojeno k DB", "Připojení k DB proběhlo úspěšně", false);
        } catch (SQLException e) {
            zobrazChybovyDialog("Spojení s DB", "Připojení k databázi selhalo", null, e, Level.SEVERE, true);
        }
    }

    private void vyzkousetSQLTlacitkoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_vyzkousetSQLTlacitkoActionPerformed
        try {
            Collection<InternetAddressKomu> adresy = getPrijemciSQL();//GEN-LAST:event_vyzkousetSQLTlacitkoActionPerformed
            if (adresy == null) {
                zobrazInformacniDialog("SQL dotaz", "Dotaz do databáze neproběhl.\nSQL dotaz je prázdný.", false);
            } else {
                zobrazInformacniDialog("SQL dotaz", "Dotaz do databáze byl úspěšný.\nPočet získaných záznamů: " + adresy.size(), false);
            }
        } catch (Exception e) {
            zobrazChybovyDialog("SQL dotaz", "Provedení SQL příkazu selhalo selhalo", null, e, Level.SEVERE, true);
        }
    }

    private void zobrazitSQLPrijemceTlacitkoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zobrazitSQLPrijemceTlacitkoActionPerformed
        try {
            Collection<InternetAddressKomu> adresy = getPrijemciSQL();

            ZobrazovacAdres zobrazovac = new ZobrazovacAdres(this, false);
			zobrazovac.setNastaveni(nastaveni);
            zobrazovac.setAdresy(adresy);
            zobrazovac.setLocationRelativeTo(this);
            zobrazovac.setVisible(true);

        } catch (Exception e) {
            zobrazChybovyDialog("SQL dotaz", "Provedení SQL příkazu selhalo selhalo", null, e, Level.SEVERE, true);
        }
    }//GEN-LAST:event_zobrazitSQLPrijemceTlacitkoActionPerformed

    private void zobrazitVsechnyPrijemceTlacitkoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zobrazitVsechnyPrijemceTlacitkoActionPerformed
        try {
            Collection<InternetAddressKomu> adresy = getPrijemciVsichni();

            ZobrazovacAdres zobrazovac = new ZobrazovacAdres(this, false);
            zobrazovac.setAdresy(adresy);
            zobrazovac.setLocationRelativeTo(this);
            zobrazovac.setVisible(true);

        } catch (Exception e) {
            zobrazChybovyDialog("SQL dotaz", "Provedení SQL příkazu selhalo selhalo", null, e, Level.SEVERE, true);
        }
    }//GEN-LAST:event_zobrazitVsechnyPrijemceTlacitkoActionPerformed

    private void odpovedetKomuOdkazActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_odpovedetKomuOdkazActionPerformed
        odpovedetKomuDialog.pack();
        odpovedetKomuDialog.setLocationRelativeTo(this);
        odpovedetKomuDialog.setModalityType(ModalityType.APPLICATION_MODAL);
        odpovedetKomuDialog.getRootPane().setDefaultButton(odpovedetKomuHotovo);
        odpovedetKomuDialog.setVisible(true);
}//GEN-LAST:event_odpovedetKomuOdkazActionPerformed

    private void odpovedetKomuHotovoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_odpovedetKomuHotovoActionPerformed
        odpovedetKomuDialog.setVisible(false);
}//GEN-LAST:event_odpovedetKomuHotovoActionPerformed

    /** Provede uživatelem zadaný SQL dotaz a vrátí získané příjemce */
    private Collection<InternetAddressKomu> getPrijemciSQL() throws SQLException, UnsupportedEncodingException {
        if ("".equals(vstupSQL.getText())) {
            return null;
        } else {
            return getSpojeni().getAdresy(vstupSQL.getText());
        }
    }

    private DataSQL getSpojeni() throws SQLException {
        return Data.getSpojeniSQL(vstupDatabaze.getText(), vstupDBjmeno.getText(), vstupDBheslo.getPassword());
    }

    /** Obalovací třída, která v průběhu odesílání zobrazuje kurzor s hodinami. */
    private void odesli(HromadnaZprava zprava) throws MessagingException {
        setCursor(new Cursor(Cursor.WAIT_CURSOR));
        try {
            postak.setNastaveni(nastaveni);
            postak.odesli(zprava);

        } catch (MessagingException e) {
            throw e;
        } finally {
            setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setPanel(JComponent komponenta) {

        if (panel.getLayout() instanceof CardLayout) {
            CardLayout l = (CardLayout) panel.getLayout();
            l.show(panel, komponenta.getName());
        } else {
            log.log(Level.WARNING, "Neplatí: panel.getLayout() instanceof CardLayout");
        }

    }

    /** Změní chování tabulátoru v textovém poli - aby se pomocí TABu dalo skočit na další komponentu */
    private void vyresitTabFocusProblem(JTextArea textArea) {
        textArea.setFocusTraversalKeys(KeyboardFocusManager.FORWARD_TRAVERSAL_KEYS, null);
        textArea.setFocusTraversalKeys(KeyboardFocusManager.BACKWARD_TRAVERSAL_KEYS, null);
    }

    public JXTaskPaneContainer getTaskPanel() {
        return taskPanel;
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        final boolean ladit = (args != null && args.length > 0 && args[0].equals("ladit"));

        try {
            //LookAndFeel laf = UIManager.getLookAndFeel();

            //laf = new SubstanceLookAndFeel();
            //laf = new SubstanceBusinessLookAndFeel();
            //laf = new SubstanceBusinessBlueSteelLookAndFeel();
            //laf = new SubstanceBusinessBlackSteelLookAndFeel();

            UIManager.setLookAndFeel("org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel");
        } catch (ClassNotFoundException ex) {
            log.log(Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            log.log(Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            log.log(Level.SEVERE, null, ex);
        } catch (UnsupportedLookAndFeelException ex) {
            log.log(Level.SEVERE, null, ex);
        }

        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new SuperPostak(ladit, true).setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private org.jdesktop.swingx.JXHeader jXHeader1;
    private org.jdesktop.swingx.JXTaskPane jXTaskPane1;
    private org.jdesktop.swingx.JXTaskPane jXTaskPane2;
    private org.jdesktop.swingx.JXHyperlink lnDatabaze;
    private org.jdesktop.swingx.JXHyperlink lnOdeslat;
    private org.jdesktop.swingx.JXHyperlink lnPrijemci;
    private org.jdesktop.swingx.JXHyperlink lnServer;
    private org.jdesktop.swingx.JXHyperlink lnText;
    private org.jdesktop.swingx.JXHyperlink lnVychoziPrijemci;
    private javax.swing.JTextArea napovedaSMTP;
    private javax.swing.JScrollPane napovedaSMTPscroll;
    private javax.swing.JTextField odpovedetKomuAdresa;
    private javax.swing.JDialog odpovedetKomuDialog;
    private javax.swing.JButton odpovedetKomuHotovo;
    private javax.swing.JTextField odpovedetKomuJmeno;
    private org.jdesktop.swingx.JXHyperlink odpovedetKomuOdkaz;
    private org.jdesktop.swingx.JXPanel panel;
    private org.jdesktop.swingx.JXPanel panelDatabaze;
    private org.jdesktop.swingx.JXPanel panelOdeslat;
    private org.jdesktop.swingx.JXPanel panelPrijemci;
    private org.jdesktop.swingx.JXPanel panelServer;
    private org.jdesktop.swingx.JXPanel panelVychoziPrijemci;
    private org.jdesktop.swingx.JXPanel panelZprava;
    private cz.frantovo.superPostak.PanelPrijemcu prijemciDodatecni;
    private cz.frantovo.superPostak.PanelPrijemcu prijemciVychozi;
    private cz.frantovo.superPostak.PanelPrijemcu prijemciZkusebni;
    private javax.swing.JButton rozeslatHromadnouZpravuTlacitko;
    private javax.swing.JButton rozeslatZkusebniTlacitko;
    private org.jdesktop.swingx.JXTaskPaneContainer taskPanel;
    private javax.swing.JTextField vstupAdresaOdesilatele;
    private javax.swing.JPasswordField vstupDBheslo;
    private javax.swing.JTextField vstupDBjmeno;
    private javax.swing.JTextField vstupDatabaze;
    private javax.swing.JCheckBox vstupFormatHTML;
    private javax.swing.JTextField vstupJmenoOdesilatele;
    private javax.swing.JTextField vstupPredmet;
    private javax.swing.JPasswordField vstupSMTPheslo;
    private javax.swing.JTextField vstupSMTPjmeno;
    private javax.swing.JSpinner vstupSMTPlimitPrijemcu;
    private javax.swing.JSpinner vstupSMTPport;
    private javax.swing.JTextField vstupSMTPserver;
    private javax.swing.JTextArea vstupSQL;
    private javax.swing.JTextArea vstupZprava;
    private javax.swing.JLabel vystupDBzprava;
    private javax.swing.JLabel vystupSQLZprava;
    private javax.swing.JButton vyzkousetPripojeniTlacitko;
    private javax.swing.JButton vyzkousetSQLTlacitko;
    private javax.swing.JButton zobrazitSQLPrijemceTlacitko;
    private javax.swing.JButton zobrazitVsechnyPrijemceTlacitko;
    // End of variables declaration//GEN-END:variables
}
