package cz.frantovo.postak;

import java.io.UnsupportedEncodingException;
import javax.mail.Message.RecipientType;
import javax.mail.internet.InternetAddress;

/**
 * Rozšíření InternetAddress tak, aby obsahovala i informaci o typu příjemce: komu, kopie, skrytá
 * @author fiki
 */
public class InternetAddressKomu extends InternetAddress {
    private static final long serialVersionUID = 5616579686371892208L;

    private RecipientType typ = RecipientType.BCC;

    /**
     * Typ příjemce: komu, kopie, skrytý.
     * Výchozí hodnota je BCC
     */
    public RecipientType getTyp() {
        return typ;
    }

    /**
     * Typ příjemce: komu, kopie, skrytý.
     * Výchozí hodnota je BCC
     */
    public void setTyp(RecipientType typ) {
        this.typ = typ;
    }

    @Override
    public String getPersonal() {
        String sup = super.getPersonal();
        if (sup == null || sup.length() < 1) {
            return getAddress();
        } else {
            return sup;
        }
    }

    public InternetAddressKomu() {
        super();
    }

    /** Výchozí typ příjemce: skrytá kopie */
    public InternetAddressKomu(String adresa, String jmeno) throws UnsupportedEncodingException {
        super(adresa, jmeno);
    }

    public InternetAddressKomu(String adresa, String jmeno, RecipientType typ) throws UnsupportedEncodingException {
        super(adresa, jmeno);
        setTyp(typ);
    }
}
