package cz.frantovo.superPostak;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Vrstva pro připojení k databázi
 * @author fiki
 */
public class Data {

    private static Logger log = Logger.getLogger(Data.class.getName());
    private static Connection spojeni;
    private static byte[] hash;
    private static MessageDigest sha;

    public static synchronized DataSQL getSpojeniSQL(String url, String jmeno, char[] heslo) throws SQLException {
        return new DataSQL(getSpojeni(url, jmeno, heslo));
    }

    private static synchronized Connection getSpojeni(String url, String jmeno, char[] heslo) throws SQLException {
        if (Arrays.equals(hash, hashuj(url, jmeno, heslo)) && spojeni != null && !spojeni.isClosed()) {
            log.log(Level.INFO, "Znovupoužívám DB spojení.");
        } else {
            spojeni = getNoveSpojeni(url, jmeno, heslo);
        }

        return spojeni;
    }

    private static Connection getNoveSpojeni(
            String url, String jmeno, char[] heslo) throws SQLException {
        /** Pokusíme se uzavřít staré spojení */
        if (spojeni != null && !spojeni.isClosed()) {
            try {
                spojeni.close();
            } catch (Exception e) {
                log.log(Level.INFO, "Nepodařilo se uzavřít spojení", e);
            }
        }

        /** Vrátíme nové spojení */
        hash = hashuj(url, jmeno, heslo);
        spojeni = DriverManager.getConnection(url, jmeno, String.valueOf(heslo));
        log.log(Level.INFO, "Otevřeno nové spoejní spojení k databázi: " + url);
        return spojeni;
    }

    private static byte[] hashuj(String url, String jmeno, char[] heslo) {
        try {
            if (sha == null) {
                sha = MessageDigest.getInstance("SHA-256");
            }
            String text = url + "/" + jmeno + "/" + String.valueOf(heslo);
            return sha.digest(text.getBytes());

        } catch (NoSuchAlgorithmException e) {
            /** Tohle by nemělo nikdy nastat. V nouzovém případě použijeme součet hodnot místo hashe. */
            log.log(Level.SEVERE, "Neexistující hashovací algoritmus", e);
            String soucet = url + "/" + jmeno + String.valueOf(heslo).length();
            return soucet.getBytes();
        }
    }
}


