/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.frantovo.superPostak;

import cz.frantovo.postak.InternetAddressKomu;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Třída pro vykonávání SQL dotazů
 * @author fiki
 */
public class DataSQL {

    private static Logger log = Logger.getLogger(DataSQL.class.getName());
    private Connection spojeni;

    public DataSQL(Connection spojeni) {
        this.spojeni = spojeni;
    }

    /**
     * Provede SQL příkaz a získá z něj e-mailové adresy.
     * Zatím předpokládá pouze jediný sloupec, který obsahuje adresu.
     */
    public Collection<InternetAddressKomu> getAdresy(String sql) throws SQLException, UnsupportedEncodingException {
        ArrayList<InternetAddressKomu> vysledek = new ArrayList<InternetAddressKomu>();

        if (sql == null || sql.length() < 3) {
            log.log(Level.FINER, "Prázdný SQL dotaz");
            return null;
        } else {
            PreparedStatement ps = spojeni.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vysledek.add(new InternetAddressKomu(rs.getString(1), rs.getString(1)));
            }
            return vysledek;
        }
    }
}
